package jadean.dean.java.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtilities {
	/*
	 * finds, if inner class (.*)$file is located in directory dir
	 */
	public static boolean innerClassInDir(String dir, String file) {
		File fDir = new File(dir);
		File[] files = fDir.listFiles();
		if (files != null) {
			for (File f: files) {
				if (f.isFile()) {
					if (f.getName().endsWith(file) && !f.getName().equals(file)) {
						return true;
					}
				}
			}
		}
		return false;
	}

	/*
	 * returns list of files in directories dir[] - NON RECURSIVE
	 */
	public static List<File> filesInDirs(List<String> dirs) {
		ArrayList<File> ret = new ArrayList<File>();

		for (String dir: dirs) {
			File f = new File(dir);
			String[] files = f.list();
			for (String s: files) {
				File _f = new File(f.getAbsolutePath(), s);
				if (!_f.isDirectory()){
					ret.add(_f);
				}
			}
		}

		return ret;
	}

	public static List<File> allFilesInDirs(List<String> dirs) {
		ArrayList<File> ret = new ArrayList<File>();

		for (String dir: dirs) {
			File f = new File(dir);
			String[] files = f.list();
			for (String file: files) {
				File _f = new File(f.getAbsolutePath(), file);
				if (!_f.isDirectory()) {
					ret.add(_f);
				}
				else {
					ret.addAll(filesInDir(_f.getAbsolutePath())); 
				}
			}
		}		

		return ret;
	}

	private static List<File> filesInDir(String dir) {
		ArrayList<File> ret = new ArrayList<File>();
		
		File f = new File(dir);
		String[] files = f.list();
		for (String s: files) {
			File _f = new File(f.getAbsolutePath(), s);
			if (!_f.isDirectory()) {
				ret.add(_f);
			}
			else {
				ret.addAll(filesInDir(_f.getAbsolutePath())); 
			}
		}		
		
		return ret;
	}

	/*
	 * finds first file in directories and return full path, or return null
	 */
	public static String findInDirs(List<String> dirs, String fileName) {
		for (String dir: dirs) {
			File f = new File(dir, fileName);
			if (f.exists()) {
				return f.getAbsolutePath(); 
			}
		}
		return null;
	}

	public static String getClassName(File f, List<String> dirs) {
		for (String dir: dirs) {
			if (f.getAbsolutePath().startsWith(dir)) {
				String absolutePath = f.getAbsolutePath();
				String relativeFileName = absolutePath.replace(dir + File.separatorChar, "");
				String relativeSourceFileName = relativeFileName.replace(".java", "");
				String relativeClassName = relativeSourceFileName.replace(File.separatorChar, '.');
				return relativeClassName; 
			}
		}
		return null;
	}

	public static void renameTo(String oldFileName, String newFileName) throws IOException {
		File oldFile = new File(oldFileName);
		File newFile = new File(newFileName);

		if (newFile.exists()) {
			if (!newFile.delete()) {
				throw new IOException();
			}
		}
		if (!oldFile.renameTo(newFile)) {
			throw new IOException();
		}
	}

	public static void copyfile(String sourceFileName, String destinationFileName) throws IOException {
		File sourceFile = new File(sourceFileName);
		File destinationFile = new File(destinationFileName);
		InputStream in = new FileInputStream(sourceFile);
		OutputStream out = new FileOutputStream(destinationFile);

		byte[] buffer = new byte[1024];
		int length;
		while ((length = in.read(buffer)) > 0){
			out.write(buffer, 0, length);
		}
		in.close();
		out.close();
	}

	public static void deleteFile(String fileName) throws IOException {
		File f = new File(fileName);
		if (!f.exists()) {
			throw new IOException("No such file or directory: " + fileName);
		}
		if (!f.canWrite()) {
			throw new IOException("Write access denied: " + fileName);
		}
		if (f.isDirectory() && f.list().length > 0) {
			throw new IOException("Directory is not empty: " + fileName);
		}
		if (!f.delete()) {
			throw new IOException("Failed to delete file: " + fileName);
		}
	}
	
	public static String inputStreamToString(InputStream input) throws IOException {
		StringBuffer sb = new StringBuffer();
		byte[] buffer = new byte[1024];
		int length;
		while ((length = input.read(buffer)) > 0){
			sb.append(new String(buffer), 0, length);
		}
		return sb.toString();
	}
}
